/**
 * Created by qjon on 06.11.13.
 */
angular.module('JsonModels', ['ngResource']).
    factory('StructureJson', function($rootScope, $resource, $q, PageJson){

        var isLoaded = false;


        var StructureObj = {};

        return {
            getPages: function(){
                return StructureObj.content.pages;
            }

            ,getPageWidth: function(){
                return parseInt(StructureObj.content.page_size['-width']);
            }

            ,getPageHeight: function(){
                return parseInt(StructureObj.content.page_size['-height']);
            }

            ,getLeftPageIndex: function(){
                var firstPageIndex = parseInt(StructureObj.content['-first_spread']);
                if(this.isFirstPageSingle())
                {
                    if(firstPageIndex == 1)
                    {
                        return false;
                    }
                    else
                    {
                        if(firstPageIndex % 2 == 0)
                        {
                            return firstPageIndex;
                        }
                        else
                        {
                            return --firstPageIndex;
                        }
                    }
                }
                else
                {
                    if(firstPageIndex % 2 == 1)
                    {
                        return firstPageIndex;
                    }
                    else
                    {
                        return --firstPageIndex;
                    }
                }
            }
            ,isFirstPage: function(page){
                return (this.getPages().indexOf(page) == 0);
            }
            ,isFirstPageSingle: function(){
                return (StructureObj.content['-firstPageSingle'] === true || (StructureObj.content['-firstPageSingle'].toLowerCase() === 'true')) ? true : false;
            }
            ,isLastPage: function(page){
                var pages = this.getPages();
                return (pages.indexOf(page) == pages.length - 1);
            }
            ,isLeftPage: function(page){
                if(this.isFirstPageSingle())
                {
                    return this.getPages().indexOf(page) % 2 !== 0;
                }
                else
                {
                    return this.getPages().indexOf(page) % 2 == 0;
                }
            }
//            ,loadData: function(){
//                if(!isLoaded)
//                {
//                    isLoaded = true;
//                    return StructureObj = StructureResource.query();
//                }
//                else
//                {
//                    return StructureObj;
//                }
//            }
            ,setData: function(data){
                StructureObj = data;
            }

            /**
             * Pobiera następną stronę względem podanej
             * @param page
             * @returns {boolean}
             */
            ,getNextPage: function(page){
                var pages = this.getPages();
                if(page == false || typeof page == 'undefined')
                {
                    return pages[0];
                }
                else
                {
                    var index = pages.indexOf(page);
                    if(index > -1)
                    {
                        ++index;
                        return (index >= pages.length) ? false : pages[index];
                    }
                    else
                    {
                        return false;
                    }
                }
            }

            /**
             * Pobiera poprzednią stronę względem podanej
             *
             * @param page
             * @returns {*}
             */
            ,getPreviousPage : function(page){
                var pages = this.getPages();
                if(page === false)
                {
                    return pages[(pages.length - 1)]
                }
                else
                {
                    var index = pages.indexOf(page);
                    if(index > 0)
                    {
                        return pages[--index];
                    }
                    else
                    {
                        return false;
                    }
                }
            }

            ,getPageById: function(id){
                var pages = this.getPages();
                var page = false;
                for(var i = 0; i < pages.length; i++)
                {
                    if(pages[i]['-id'] == id)
                    {
                        page = pages[i];
                        break;
                    }
                }
                return page;
            }
        }
    })
    .factory('PageJson', function($rootScope, PageResource){
        /**
         * List of loaded pages
         * @type {{}}
         */
        var loadedPages = {}
        var loadedPageSourceData = {};

//        var PageResource = $resource(debugModeUrl + '/data/:page',{},{
//                query: {
//                    method: "GET"
//                    ,transformResponse: function(data){
//                        var sourceData = angular.fromJson(data);
//                        sourceData['-id'] = loadedPageSourceData['-id'];
//                        return new MbPage(sourceData);
//                    }
//                }
//            }
//        );

        return {
            loadPage: function(page){
                loadedPageSourceData = page;
                if(page === false || typeof page == 'undefined')
                {
                    return {};
                }

                if(typeof page['interactionsPath'] == 'undefined' || page['interactionsPath'] == '')
                {
                    return {};
                }

                if(typeof loadedPages[page['-number']] == 'undefined')
                {
                    loadedPages[page['-number']] = PageResource.query({page: page['interactionsPath']})
                }
                return loadedPages[page['-number']];
            }
//            ,loadPageById: function(pageId){
//                StructureJson.loadData(this.load)
//            }
//            ,load: function(data){
//                console.log(data);
//            }
        }
    })

;